/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.store;

import java.util.concurrent.Callable;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.store.ExecutorServiceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejoinAwareBlockingOperation<V>
implements Callable<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RejoinAwareBlockingOperation.class);
    private final Callable<V> delegateCallable;
    private final ExecutorServiceStore executorServiceStore;
    private volatile Thread executingThread;
    private volatile boolean rejoinHappened;

    public RejoinAwareBlockingOperation(ExecutorServiceStore executorServiceStore, Callable<V> callable) {
        this.executorServiceStore = executorServiceStore;
        this.delegateCallable = callable;
    }

    @Override
    public V call() throws Exception {
        this.executingThread = Thread.currentThread();
        return this.executeUntilComplete();
    }

    private V executeUntilComplete() throws Exception {
        while (true) {
            try {
                this.rejoinHappened = false;
                this.executorServiceStore.executeClusterOperationNoTimeout(new ClusterOperation<V>(){

                    @Override
                    public V performClusterOperation() throws Exception {
                        return RejoinAwareBlockingOperation.this.delegateCallable.call();
                    }

                    @Override
                    public V performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                        throw new AssertionError((Object)"This should never happen as executed with no-timeout");
                    }
                });
                return this.delegateCallable.call();
            }
            catch (InterruptedException e) {
                if (this.rejoinHappened) {
                    LOGGER.debug("Caught InterruptedException caused by rejoin. Executing callable again.");
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void clusterRejoined() {
        this.rejoinHappened = true;
        if (this.executingThread != null) {
            LOGGER.debug("Interrupting executing thread (id=" + this.executingThread.getId() + ", name='" + this.executingThread.getName() + "') as rejoin happened");
            this.executingThread.interrupt();
        }
    }
}

