/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.x.protobuf.MysqlxCrud;
import com.mysql.cj.x.protobuf.MysqlxDatatypes;
import com.mysql.cj.x.protobuf.MysqlxExpr;
import com.mysql.cj.xdevapi.ExprParser;
import com.mysql.cj.xdevapi.ExprUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FilterParams {
    protected MysqlxCrud.Collection collection;
    protected Long limit;
    protected Long offset;
    protected String[] orderExpr;
    private List<MysqlxCrud.Order> order;
    protected String criteriaStr;
    private MysqlxExpr.Expr criteria;
    protected MysqlxDatatypes.Scalar[] args;
    private Map<String, Integer> placeholderNameToPosition;
    protected boolean isRelational;

    public FilterParams(String schemaName, String collectionName, boolean isRelational) {
        this.collection = ExprUtil.buildCollection(schemaName, collectionName);
        this.isRelational = isRelational;
    }

    public FilterParams(String schemaName, String collectionName, String criteriaString, boolean isRelational) {
        this.collection = ExprUtil.buildCollection(schemaName, collectionName);
        this.isRelational = isRelational;
        this.setCriteria(criteriaString);
    }

    protected FilterParams(MysqlxCrud.Collection coll, boolean isRelational) {
        this.collection = coll;
        this.isRelational = isRelational;
    }

    public Object getCollection() {
        return this.collection;
    }

    public Object getOrder() {
        return this.order;
    }

    public void setOrder(String ... orderExpression) {
        this.orderExpr = orderExpression;
        this.order = new ExprParser(Arrays.stream(orderExpression).collect(Collectors.joining(", ")), this.isRelational).parseOrderSpec();
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Object getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String criteriaString) {
        this.criteriaStr = criteriaString;
        ExprParser parser = new ExprParser(criteriaString, this.isRelational);
        this.criteria = parser.parse();
        if (parser.getPositionalPlaceholderCount() > 0) {
            this.placeholderNameToPosition = parser.getPlaceholderNameToPositionMap();
            this.args = new MysqlxDatatypes.Scalar[parser.getPositionalPlaceholderCount()];
        }
    }

    public Object getArgs() {
        if (this.args == null) {
            return null;
        }
        return Arrays.asList(this.args);
    }

    public void addArg(String name, Object value) {
        if (this.args == null) {
            throw new WrongArgumentException("No placeholders");
        }
        if (this.placeholderNameToPosition.get(name) == null) {
            throw new WrongArgumentException("Unknown placeholder: " + name);
        }
        this.args[this.placeholderNameToPosition.get((Object)name).intValue()] = ExprUtil.argObjectToScalar(value);
    }

    public void verifyAllArgsBound() {
        if (this.args != null) {
            IntStream.range(0, this.args.length).filter(i -> this.args[i] == null).mapToObj(i -> this.placeholderNameToPosition.entrySet().stream().filter(e -> (Integer)e.getValue() == i).map(Map.Entry::getKey).findFirst().get()).forEach(name -> {
                throw new WrongArgumentException("Placeholder '" + name + "' is not bound");
            });
        }
    }

    public void clearArgs() {
        if (this.args != null) {
            IntStream.range(0, this.args.length).forEach(i -> {
                this.args[i] = null;
            });
        }
    }

    public boolean isRelational() {
        return this.isRelational;
    }
}

