/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache.impl;

import com.xiaoleilu.hutool.cache.impl.AbstractCache;
import com.xiaoleilu.hutool.cache.impl.CacheObj;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends AbstractCache<K, V> {
    public LRUCache(int capacity) {
        this(capacity, 0L);
    }

    public LRUCache(int capacity, long timeout) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap<K, CacheObj<K, V>>(capacity + 1, 1.0f, true){
            private static final long serialVersionUID = -1806954614512571136L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CacheObj<K, V>> eldest) {
                if (LRUCache.this.capacity == 0) {
                    return false;
                }
                return this.size() > LRUCache.this.capacity;
            }
        };
    }

    @Override
    protected int pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }
}

