/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.ComThread;
import com.jacob.com.JacobObject;
import com.jacob.com.LibraryLoader;
import com.jacob.com.SafeArray;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ROT {
    protected static final boolean USE_AUTOMATIC_GARBAGE_COLLECTION = "true".equalsIgnoreCase(System.getProperty("com.jacob.autogc"));
    protected static final Boolean INCLUDE_ALL_CLASSES_IN_ROT = Boolean.valueOf(System.getProperty("com.jacob.includeAllClassesInROT", "true"));
    protected static String PUT_IN_ROT_SUFFIX = ".PutInROT";
    private static ThreadLocal<Map<JacobObject, String>> rot = new ThreadLocal();

    protected static synchronized Map<JacobObject, String> addThread() {
        AbstractMap tab = rot.get();
        if (tab == null) {
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: Automatic GC flag == " + USE_AUTOMATIC_GARBAGE_COLLECTION);
            }
            tab = !USE_AUTOMATIC_GARBAGE_COLLECTION ? new HashMap<JacobObject, String>() : new WeakHashMap<JacobObject, String>();
            rot.set(tab);
        }
        return tab;
    }

    protected static synchronized Map<JacobObject, String> getThreadObjects(boolean createIfDoesNotExist) {
        Map<JacobObject, String> tab = rot.get();
        if (tab == null && createIfDoesNotExist) {
            tab = ROT.addThread();
        }
        return tab;
    }

    protected static void clearObjects() {
        Map<JacobObject, String> tab = ROT.getThreadObjects(false);
        if (tab != null) {
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: " + tab.keySet().size() + " objects to clear in this thread's ROT ");
            }
            for (JacobObject o : tab.keySet()) {
                if (o == null) continue;
                if (JacobObject.isDebugEnabled()) {
                    if (o instanceof SafeArray) {
                        JacobObject.debug("ROT: removing " + o.getClass().getName());
                    } else {
                        JacobObject.debug("ROT: removing " + o.hashCode() + "->" + o.getClass().getName());
                    }
                }
                o.safeRelease();
            }
            tab.clear();
            ROT.removeThread();
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: thread table cleared and removed");
            }
        } else if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ROT: nothing to clear!");
        }
    }

    private static synchronized void removeThread() {
        rot.remove();
    }

    @Deprecated
    protected static void removeObject(JacobObject o) {
        Map<JacobObject, String> tab = ROT.getThreadObjects(false);
        if (tab != null) {
            tab.remove(o);
        }
        o.safeRelease();
    }

    protected static void addObject(JacobObject o) {
        String shouldIncludeClassInROT = "true";
        if (!INCLUDE_ALL_CLASSES_IN_ROT.booleanValue()) {
            shouldIncludeClassInROT = System.getProperty(o.getClass().getName() + PUT_IN_ROT_SUFFIX, "true");
        }
        if (shouldIncludeClassInROT.equalsIgnoreCase("false")) {
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("JacobObject: New instance of " + o.getClass().getName() + " not added to ROT");
            }
        } else {
            Map<JacobObject, String> tab = ROT.getThreadObjects(false);
            if (tab == null) {
                ComThread.InitMTA(false);
                tab = ROT.getThreadObjects(true);
            }
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: adding " + o + "->" + o.getClass().getName() + " table size prior to addition:" + tab.size());
            }
            if (tab != null) {
                tab.put(o, null);
            }
        }
    }

    static {
        LibraryLoader.loadJacobLibrary();
    }
}

