/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.ModBus;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.ModBus.IModbus;
import HslCommunication.ModBus.ModbusInfo;
import HslCommunication.Serial.SoftCRC16;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.util.ArrayList;

public class ModbusHelper {
    public static OperateResultExOne<byte[]> ExtraRtuResponseContent(byte[] send, byte[] response) {
        if (response.length < 5) {
            return new OperateResultExOne<byte[]>(StringResources.Language.ReceiveDataLengthTooShort() + "5");
        }
        if (!SoftCRC16.CheckCRC16(response)) {
            return new OperateResultExOne<byte[]>(StringResources.Language.ModbusCRCCheckFailed() + SoftBasic.ByteToHexString(response, ' '));
        }
        if (send[1] + 128 == response[1]) {
            return new OperateResultExOne<byte[]>(response[2], ModbusInfo.GetDescriptionByErrorCode(response[2]));
        }
        if (send[1] != response[1]) {
            return new OperateResultExOne<byte[]>(response[1], "Receive Command Check Failed: ");
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeRtuCommandToCore(response));
    }

    public static OperateResultExOne<byte[]> Read(IModbus modbus, String address, short length) {
        OperateResultExOne<String> modbusAddress = modbus.TranslateToModbusAddress(address, (byte)3);
        if (!modbusAddress.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(modbusAddress);
        }
        OperateResultExOne<byte[][]> command = ModbusInfo.BuildReadModbusCommand((String)modbusAddress.Content, length, modbus.getStation(), modbus.getAddressStartWithZero(), (byte)3);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        ArrayList<Byte> resultArray = new ArrayList<Byte>();
        for (int i = 0; i < ((byte[][])command.Content).length; ++i) {
            OperateResultExOne<byte[]> read = modbus.ReadFromCoreServer(((byte[][])command.Content)[i]);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            Utilities.ArrayListAddArray(resultArray, (byte[])read.Content);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBytes(resultArray));
    }

    public static OperateResult Write(IModbus modbus, String address, byte[] value) {
        OperateResultExOne<String> modbusAddress = modbus.TranslateToModbusAddress(address, (byte)16);
        if (!modbusAddress.IsSuccess) {
            return modbusAddress;
        }
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteWordModbusCommand((String)modbusAddress.Content, value, modbus.getStation(), modbus.getAddressStartWithZero(), (byte)16);
        if (!command.IsSuccess) {
            return command;
        }
        return modbus.ReadFromCoreServer((byte[])command.Content);
    }

    public static OperateResult Write(IModbus modbus, String address, short value) {
        OperateResultExOne<String> modbusAddress = modbus.TranslateToModbusAddress(address, (byte)6);
        if (!modbusAddress.IsSuccess) {
            return modbusAddress;
        }
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteWordModbusCommand((String)modbusAddress.Content, value, modbus.getStation(), modbus.getAddressStartWithZero(), (byte)6);
        if (!command.IsSuccess) {
            return command;
        }
        return modbus.ReadFromCoreServer((byte[])command.Content);
    }

    public static OperateResult WriteMask(IModbus modbus, String address, short andMask, short orMask) {
        OperateResultExOne<String> modbusAddress = modbus.TranslateToModbusAddress(address, (byte)22);
        if (!modbusAddress.IsSuccess) {
            return modbusAddress;
        }
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteMaskModbusCommand((String)modbusAddress.Content, andMask, orMask, modbus.getStation(), modbus.getAddressStartWithZero(), (byte)22);
        if (!command.IsSuccess) {
            return command;
        }
        return modbus.ReadFromCoreServer((byte[])command.Content);
    }

    public static OperateResultExOne<boolean[]> ReadBoolHelper(IModbus modbus, String address, short length, byte function) {
        OperateResultExOne<String> modbusAddress = modbus.TranslateToModbusAddress(address, function);
        if (!modbusAddress.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(modbusAddress);
        }
        if (((String)modbusAddress.Content).indexOf(46) > 0) {
            String[] addressSplits = Utilities.SplitDot(address);
            int bitIndex = 0;
            try {
                bitIndex = Integer.parseInt(addressSplits[1]);
            }
            catch (Exception ex) {
                return new OperateResultExOne<boolean[]>("Bit Index format wrong, " + ex.getMessage());
            }
            short len = (short)((length + bitIndex + 15) / 16);
            OperateResultExOne<byte[]> read = modbus.Read(addressSplits[0], len);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            return OperateResultExOne.CreateSuccessResult(SoftBasic.BoolArraySelectMiddle(SoftBasic.ByteToBoolArray(SoftBasic.BytesReverseByWord((byte[])read.Content)), bitIndex, length));
        }
        OperateResultExOne<byte[][]> command = ModbusInfo.BuildReadModbusCommand((String)modbusAddress.Content, length, modbus.getStation(), modbus.getAddressStartWithZero(), function);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        ArrayList<Boolean> resultArray = new ArrayList<Boolean>();
        for (int i = 0; i < ((byte[][])command.Content).length; ++i) {
            OperateResultExOne<byte[]> read = modbus.ReadFromCoreServer(((byte[][])command.Content)[i]);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            int bitLength = (((byte[][])command.Content)[i][4] & 0xFF) * 256 + (((byte[][])command.Content)[i][5] & 0xFF);
            Utilities.ArrayListAddArray(resultArray, SoftBasic.ByteToBoolArray((byte[])read.Content, bitLength));
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBools(resultArray));
    }

    public static OperateResult Write(IModbus modbus, String address, boolean[] values) {
        OperateResultExOne<String> modbusAddress = modbus.TranslateToModbusAddress(address, (byte)15);
        if (!modbusAddress.IsSuccess) {
            return modbusAddress;
        }
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteBoolModbusCommand((String)modbusAddress.Content, values, modbus.getStation(), modbus.getAddressStartWithZero(), (byte)15);
        if (!command.IsSuccess) {
            return command;
        }
        return modbus.ReadFromCoreServer((byte[])command.Content);
    }

    public static OperateResult Write(IModbus modbus, String address, boolean value) {
        OperateResultExOne<String> modbusAddress = modbus.TranslateToModbusAddress(address, (byte)5);
        if (!modbusAddress.IsSuccess) {
            return modbusAddress;
        }
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteBoolModbusCommand((String)modbusAddress.Content, value, modbus.getStation(), modbus.getAddressStartWithZero(), (byte)5);
        if (!command.IsSuccess) {
            return command;
        }
        return modbus.ReadFromCoreServer((byte[])command.Content);
    }
}

