/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net.NetworkBase;

import HslCommunication.Authorization;
import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Net.NetworkBase.NetworkBase;
import HslCommunication.Core.Thread.SimpleHybirdLock;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.StringResources;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class NetworkUdpBase
extends NetworkBase {
    private String ipAddress = "127.0.0.1";
    private int port = 10000;
    private int receiveTimeOut = 10000;
    private String connectionId = "";
    protected SimpleHybirdLock simpleHybirdLock = new SimpleHybirdLock();
    private DatagramSocket datagramSocket;
    private DatagramPacket datagramPacket;
    private int receiveCacheLength = 2048;

    public NetworkUdpBase() {
        this.connectionId = SoftBasic.GetUniqueStringByGuidAndRandom();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public void setReceiveTimeOut(int receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public int getReceiveCacheLength() {
        return this.receiveCacheLength;
    }

    public void setReceiveCacheLength(int receiveCacheLength) {
        this.receiveCacheLength = receiveCacheLength;
    }

    protected byte[] PackCommandWithHeader(byte[] command) {
        return command;
    }

    protected OperateResultExOne<byte[]> UnpackResponseContent(byte[] send, byte[] response) {
        return OperateResultExOne.CreateSuccessResult(response);
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(byte[] send) {
        return this.ReadFromCoreServer(send, true, true);
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(byte[] send, boolean hasResponseData, boolean usePackAndUnpack) {
        byte[] sendValue;
        if (!Authorization.nzugaydgwadawdibbas()) {
            return new OperateResultExOne<byte[]>(StringResources.Language.AuthorizationFailed());
        }
        byte[] byArray = sendValue = usePackAndUnpack ? this.PackCommandWithHeader(send) : send;
        if (this.LogNet != null) {
            this.LogNet.WriteDebug(this.toString(), StringResources.Language.Send() + " : " + SoftBasic.ByteToHexString(sendValue));
        }
        this.simpleHybirdLock.Enter();
        try {
            this.datagramSocket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(this.getIpAddress());
            this.datagramPacket = new DatagramPacket(sendValue, sendValue.length, address, this.getPort());
            this.datagramSocket.send(this.datagramPacket);
            if (this.getReceiveTimeOut() > 0) {
                this.datagramSocket.setSoTimeout(this.getReceiveTimeOut());
            }
            if (this.getReceiveTimeOut() < 0) {
                this.simpleHybirdLock.Leave();
                return OperateResultExOne.CreateSuccessResult(new byte[0]);
            }
            if (!hasResponseData) {
                this.simpleHybirdLock.Leave();
                return OperateResultExOne.CreateSuccessResult(new byte[0]);
            }
            byte[] buffer = new byte[this.getReceiveCacheLength()];
            DatagramPacket recePacket = new DatagramPacket(buffer, buffer.length);
            this.datagramSocket.receive(recePacket);
            byte[] receive = SoftBasic.BytesArraySelectBegin(buffer, recePacket.getLength());
            this.simpleHybirdLock.Leave();
            if (this.LogNet != null) {
                this.LogNet.WriteDebug(this.toString(), StringResources.Language.Receive() + " : " + SoftBasic.ByteToHexString(receive));
            }
            return usePackAndUnpack ? this.UnpackResponseContent(sendValue, receive) : OperateResultExOne.CreateSuccessResult(receive);
        }
        catch (Exception ex) {
            this.simpleHybirdLock.Leave();
            return new OperateResultExOne<byte[]>(ex.getMessage());
        }
    }

    @Override
    public String toString() {
        return "NetworkUdpBase[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

