package HslCommunication.Core.IMessage;

import HslCommunication.Utilities;

import java.nio.charset.StandardCharsets;

public class OpenProtocolMessage extends NetMessageBase implements INetMessage {
    public int ProtocolHeadBytesLength(){
        return 4;
    }

    public int GetContentLengthByHeadBytes() {
        byte[] HeadBytes = getHeadBytes();
        byte[] SendBytes = getSendBytes();
        if (HeadBytes == null) return 0;
        if (HeadBytes.length >= 4) {
            int length = Integer.parseInt( new String(HeadBytes, 0, 4, StandardCharsets.US_ASCII) ) - 4;
            if (length < 0) length = 0;
            return length;
        } else
            return 0;
    }
}
