package HslCommunication.CNC.Fanuc;

/**
 * 当前机床的报警信息
 */
public class SysAlarm {
    /**
     * 当前报警的ID信息
     */
    public int AlarmId = 0;

    /**
     * 当前的报警类型
     */
    public short Type = 0;

    /**
     * 报警的轴信息
     */
    public short Axis = 0;

    /**
     * 报警的消息
     */
    public String Message = "";

    public String toString(){
        return "AlarmId:[" + AlarmId + "] Type:[" + Type + "] Axis:[" + Axis + "] Message: " + Message ;
    }

    public static String GetArrayString( SysAlarm[] alarms ){
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i=0;i<alarms.length;i++){
            stringBuilder.append("\r\n  ");
            stringBuilder.append(alarms[i].toString());
        }
        stringBuilder.append("\r\n]");
        return stringBuilder.toString();
    }
}
