/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jakarta;

import com.alibaba.druid.filter.stat.StatFilterContext;
import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebSessionStat;
import com.alibaba.druid.support.http.stat.WebURIStat;
import com.alibaba.druid.support.jakarta.AbstractWebStatImpl;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.support.profile.ProfileEntryKey;
import com.alibaba.druid.support.profile.ProfileEntryReqStat;
import com.alibaba.druid.support.profile.Profiler;
import com.alibaba.druid.util.DruidWebUtils;
import com.alibaba.druid.util.PatternMatcher;
import com.alibaba.druid.util.ServletPathMatcher;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WebStatFilter
extends AbstractWebStatImpl
implements Filter {
    private static final Log LOG = LogFactory.getLog(WebStatFilter.class);
    public static final String PARAM_NAME_PROFILE_ENABLE = "profileEnable";
    public static final String PARAM_NAME_SESSION_STAT_ENABLE = "sessionStatEnable";
    public static final String PARAM_NAME_SESSION_STAT_MAX_COUNT = "sessionStatMaxCount";
    public static final String PARAM_NAME_EXCLUSIONS = "exclusions";
    public static final String PARAM_NAME_PRINCIPAL_SESSION_NAME = "principalSessionName";
    public static final String PARAM_NAME_PRINCIPAL_COOKIE_NAME = "principalCookieName";
    public static final String PARAM_NAME_REAL_IP_HEADER = "realIpHeader";
    protected final PatternMatcher pathMatcher = ServletPathMatcher.getInstance();
    private Set<String> excludesPattern;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int index;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        StatHttpServletResponseWrapper responseWrapper = new StatHttpServletResponseWrapper(httpResponse);
        String requestURI = this.getRequestURI(httpRequest);
        if (this.isExclusion(requestURI)) {
            chain.doFilter(request, response);
            return;
        }
        long startNano = System.nanoTime();
        long startMillis = System.currentTimeMillis();
        WebRequestStat requestStat = new WebRequestStat(startNano, startMillis);
        WebRequestStat.set(requestStat);
        WebSessionStat sessionStat = this.getSessionStat(httpRequest);
        this.webAppStat.beforeInvoke();
        WebURIStat uriStat = this.webAppStat.getURIStat(requestURI, false);
        if (uriStat == null && (index = requestURI.indexOf(";jsessionid=")) != -1) {
            requestURI = requestURI.substring(0, index);
            uriStat = this.webAppStat.getURIStat(requestURI, false);
        }
        if (this.isProfileEnable()) {
            Profiler.initLocal();
            Profiler.enter(requestURI, "WEB");
        }
        if (uriStat != null) {
            uriStat.beforeInvoke();
        }
        if (sessionStat != null) {
            sessionStat.beforeInvoke();
        }
        Throwable error = null;
        try {
            chain.doFilter(request, (ServletResponse)responseWrapper);
        }
        catch (IOException e) {
            error = e;
            throw e;
        }
        catch (ServletException e) {
            error = e;
            throw e;
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Error e) {
            error = e;
            throw e;
        }
        finally {
            long endNano = System.nanoTime();
            requestStat.setEndNano(endNano);
            long nanos = endNano - startNano;
            this.webAppStat.afterInvoke(error, nanos);
            if (sessionStat == null && (sessionStat = this.getSessionStat(httpRequest)) != null) {
                sessionStat.beforeInvoke();
            }
            if (sessionStat != null) {
                sessionStat.afterInvoke(error, nanos);
                sessionStat.setPrincipal(this.getPrincipal(httpRequest));
            }
            if (uriStat == null) {
                int status = responseWrapper.getStatus();
                if (status == 404) {
                    String errorUrl = this.contextPath + "error_" + status;
                    uriStat = this.webAppStat.getURIStat(errorUrl, true);
                } else {
                    uriStat = this.webAppStat.getURIStat(requestURI, true);
                }
                if (uriStat != null) {
                    uriStat.beforeInvoke();
                }
            }
            if (uriStat != null) {
                uriStat.afterInvoke(error, nanos);
            }
            WebRequestStat.set(null);
            if (this.isProfileEnable()) {
                Profiler.release(nanos);
                Map<ProfileEntryKey, ProfileEntryReqStat> requestStatsMap = Profiler.getStatsMap();
                if (uriStat != null) {
                    uriStat.getProfiletat().record(requestStatsMap);
                }
                Profiler.removeLocal();
            }
        }
    }

    public boolean isExclusion(String requestURI) {
        if (this.excludesPattern == null || requestURI == null) {
            return false;
        }
        if (this.contextPath != null && requestURI.startsWith(this.contextPath) && !(requestURI = requestURI.substring(this.contextPath.length())).startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        for (String pattern : this.excludesPattern) {
            if (!this.pathMatcher.matches(pattern, requestURI)) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig config) throws ServletException {
        String param;
        String exclusions = config.getInitParameter(PARAM_NAME_EXCLUSIONS);
        if (exclusions != null && exclusions.trim().length() != 0) {
            this.excludesPattern = new HashSet<String>(Arrays.asList(exclusions.split("\\s*,\\s*")));
        }
        if ((param = config.getInitParameter(PARAM_NAME_PRINCIPAL_SESSION_NAME)) != null && (param = param.trim()).length() != 0) {
            this.principalSessionName = param;
        }
        if ((param = config.getInitParameter(PARAM_NAME_PRINCIPAL_COOKIE_NAME)) != null && (param = param.trim()).length() != 0) {
            this.principalCookieName = param;
        }
        if ((param = config.getInitParameter(PARAM_NAME_SESSION_STAT_ENABLE)) != null && param.trim().length() != 0) {
            if ("true".equals(param = param.trim())) {
                this.sessionStatEnable = true;
            } else if ("false".equals(param)) {
                this.sessionStatEnable = false;
            } else {
                LOG.error("WebStatFilter Parameter 'sessionStatEnable' config error");
            }
        }
        if ((param = config.getInitParameter(PARAM_NAME_PROFILE_ENABLE)) != null && param.trim().length() != 0) {
            if ("true".equals(param = param.trim())) {
                this.profileEnable = true;
            } else if ("false".equals(param)) {
                this.profileEnable = false;
            } else {
                LOG.error("WebStatFilter Parameter 'profileEnable' config error");
            }
        }
        if ((param = config.getInitParameter(PARAM_NAME_SESSION_STAT_MAX_COUNT)) != null && param.trim().length() != 0) {
            param = param.trim();
            try {
                this.sessionStatMaxCount = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                LOG.error("WebStatFilter Parameter 'sessionStatEnable' config error", e);
            }
        }
        if ((param = config.getInitParameter(PARAM_NAME_REAL_IP_HEADER)) != null && (param = param.trim()).length() != 0) {
            this.realIpHeader = param;
        }
        StatFilterContext.getInstance().addContextListener(this.statFilterContextListener);
        this.contextPath = DruidWebUtils.getContextPath(config.getServletContext());
        if (this.webAppStat == null) {
            this.webAppStat = new WebAppStat(this.contextPath, this.sessionStatMaxCount);
        }
        WebAppStatManager.getInstance().addWebAppStatSet(this.webAppStat);
    }

    public void destroy() {
        StatFilterContext.getInstance().removeContextListener(this.statFilterContextListener);
        if (this.webAppStat != null) {
            WebAppStatManager.getInstance().remove(this.webAppStat);
        }
    }

    public void setWebAppStat(WebAppStat webAppStat) {
        this.webAppStat = webAppStat;
    }

    public WebAppStat getWebAppStat() {
        return this.webAppStat;
    }

    public AbstractWebStatImpl.WebStatFilterContextListener getStatFilterContextListener() {
        return this.statFilterContextListener;
    }

    public static final class StatHttpServletResponseWrapper
    extends HttpServletResponseWrapper
    implements HttpServletResponse {
        private int status = 200;

        public StatHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int statusCode) {
            super.setStatus(statusCode);
            this.status = statusCode;
        }

        public void setStatus(int statusCode, String statusMessage) {
            super.setStatus(statusCode);
            super.setStatus(statusCode);
            this.status = statusCode;
        }

        public void sendError(int statusCode, String statusMessage) throws IOException {
            super.sendError(statusCode, statusMessage);
            this.status = statusCode;
        }

        public void sendError(int statusCode) throws IOException {
            super.sendError(statusCode);
            this.status = statusCode;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

