/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.dialect.teradata.ast.TDCreateTableStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class TDCreateTableParser
extends SQLCreateTableParser {
    public TDCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.teradata;
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement createTable) {
        this.parseTableType(createTable);
        this.parseTableType(createTable);
    }

    private void parseTableType(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIf(Token.SET)) {
            createTable.config(SQLCreateTableStatement.Feature.Set);
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.MULTISET)) {
            createTable.config(SQLCreateTableStatement.Feature.MultiSet);
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.GLOBAL)) {
            createTable.config(SQLCreateTableStatement.Feature.Global);
            this.acceptIdentifier(FnvHash.Constants.TEMPORARY);
            createTable.config(SQLCreateTableStatement.Feature.Temporary);
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.VOLATILE)) {
            createTable.config(SQLCreateTableStatement.Feature.Volatile);
        }
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        super.parseCreateTableRest(stmt);
        if (stmt instanceof TDCreateTableStatement) {
            if (this.lexer.token() == Token.PRIMARY) {
                SQLPrimaryKey sqlPrimaryKey = this.exprParser.parsePrimaryKey();
                ((TDCreateTableStatement)stmt).setPrimaryKey(sqlPrimaryKey);
            }
            if (this.lexer.nextIf(Token.ON)) {
                this.acceptIdentifier("COMMIT");
                if (this.lexer.nextIf(Token.DELETE)) {
                    ((TDCreateTableStatement)stmt).setOnCommitRows(TDCreateTableStatement.OnCommitType.DELETE);
                } else if (this.lexer.nextIfIdentifier("PRESERVE")) {
                    ((TDCreateTableStatement)stmt).setOnCommitRows(TDCreateTableStatement.OnCommitType.PRESERVE);
                } else {
                    throw new ParserException("syntax error " + this.lexer.info());
                }
                this.acceptIdentifier("ROWS");
            }
        }
    }

    @Override
    protected SQLCreateTableStatement newCreateStatement() {
        return new TDCreateTableStatement(this.getDbType());
    }
}

