/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.presto.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.dialect.presto.ast.PrestoColumnWith;
import com.alibaba.druid.sql.dialect.presto.ast.PrestoDateTimeExpr;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterFunctionStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoDeallocatePrepareStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoExecuteStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoPrepareStatement;
import com.alibaba.druid.sql.dialect.presto.visitor.PrestoASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.math.BigDecimal;

public class PrestoOutputVisitor
extends SQLASTOutputVisitor
implements PrestoASTVisitor {
    public PrestoOutputVisitor(StringBuilder appender) {
        super(appender, DbType.presto);
        this.dbType = DbType.presto;
    }

    public PrestoOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.presto;
    }

    @Override
    public boolean visit(SQLLimit x) {
        if (x.getOffset() != null) {
            this.print0(this.ucase ? " OFFSET " : " offset ");
            x.getOffset().accept(this);
        }
        this.print0(this.ucase ? " LIMIT " : " limit ");
        x.getRowCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDecimalExpr x) {
        BigDecimal value = x.getValue();
        this.print0(this.ucase ? "DECIMAL '" : "decimal '");
        this.print(value.toString());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        this.printCreateTable(x, false);
        this.printTableOptions(x);
        this.printSelectAs(x, true);
        return false;
    }

    @Override
    protected void printTableOption(SQLExpr name, SQLExpr value, int index) {
        if (index != 0) {
            this.print(",");
            this.println();
        }
        String key = name.toString();
        this.print0(key);
        this.print0(" = ");
        value.accept(this);
    }

    @Override
    public boolean visit(PrestoAlterFunctionStatement x) {
        this.print0(this.ucase ? "ALTER FUNCTION " : "alter function ");
        x.getName().accept(this);
        if (x.isCalledOnNullInput()) {
            this.print0(" CALLED ON NULL INPUT");
        }
        if (x.isReturnsNullOnNullInput()) {
            this.print0(" RETURNS NULL ON NULL INPUT");
        }
        return false;
    }

    @Override
    public boolean visit(PrestoAlterSchemaStatement x) {
        this.print0(this.ucase ? "ALTER SCHEMA " : "alter achema ");
        x.getSchemaName().accept(this);
        this.print0(this.ucase ? " RENAME TO " : " rename to ");
        x.getNewName().accept(this);
        return false;
    }

    @Override
    protected void printTableOptionsPrefix(SQLCreateTableStatement x) {
        this.println();
        this.print0(this.ucase ? "WITH (" : "with (");
        this.incrementIndent();
        this.println();
    }

    @Override
    public boolean visit(SQLArrayExpr x) {
        this.print0(this.ucase ? "ARRAY[" : "array[");
        this.printAndAccept(x.getValues(), ", ");
        this.print(']');
        return false;
    }

    @Override
    public boolean visit(PrestoPrepareStatement x) {
        this.print0(this.ucase ? "PREPARE " : "prepare ");
        x.getName().accept(this);
        this.print0(this.ucase ? " FROM " : " from ");
        if (x.getSelect() != null) {
            x.getSelect().accept(this);
        } else if (x.getInsert() != null) {
            x.getInsert().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(PrestoExecuteStatement x) {
        this.print0(this.ucase ? "EXECUTE " : "execute ");
        x.getStatementName().accept(this);
        if (x.getParameters().size() > 0) {
            this.print0(this.ucase ? " USING " : " using ");
            this.printAndAccept(x.getParameters(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(PrestoDeallocatePrepareStatement x) {
        this.print0(this.ucase ? "DEALLOCATE PREPARE " : "deallocate prepare ");
        x.getStatementName().accept(this);
        return false;
    }

    @Override
    public boolean visit(PrestoColumnWith x) {
        this.print0(this.ucase ? "WITH(" : "with(");
        this.printAndAccept(x.getProperties(), ",");
        this.print0(")");
        return false;
    }

    @Override
    public boolean visit(PrestoDateTimeExpr x) {
        x.getExpr().accept(this);
        SQLExpr timeZone = x.getTimeZone();
        this.print0(this.ucase ? " AT TIME ZONE " : " at time zone ");
        timeZone.accept(this);
        return false;
    }
}

