/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionByValue;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.SQLSubPartitionByRange;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraintImpl;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLTableLike;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlPartitionSingle;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExtPartition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByList;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByValue;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.MySqlUtils;
import java.util.HashSet;
import java.util.Set;

public class MySqlCreateTableParser
extends SQLCreateTableParser {
    protected final Set<Long> supportOptions = new HashSet<Long>();

    public MySqlCreateTableParser(String sql) {
        super(new MySqlExprParser(sql));
        String[] supportOptions;
        for (String supportName : supportOptions = new String[]{"PAGE_CHECKSUM", "TRANSACTIONAL", "BLOCK_FORMAT", "REPLICA_NUM", "TABLET_SIZE", "USE_BLOOM_FILTER", "AUTO_INCREMENT", "AVG_ROW_LENGTH", "CHECKSUM", "CONNECTION", "DELAY_KEY_WRITE", "FULLTEXT_DICT", "INSERT_METHOD", "KEY_BLOCK_SIZE", "MAX_ROWS", "MIN_ROWS", "PACK_KEYS", "PASSWORD", "ROW_FORMAT", "STATS_AUTO_RECALC", "STATS_PERSISTENT", "STATS_SAMPLE_PAGES", "STORAGE_TYPE", "TABLE_PROPERTIES", "ENCRYPTION", "COMPRESSION", "STORAGE_POLICY"}) {
            this.supportOptions.add(FnvHash.hashCode64(supportName));
        }
    }

    public MySqlCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        String[] supportOptions;
        for (String supportName : supportOptions = new String[]{"PAGE_CHECKSUM", "TRANSACTIONAL", "BLOCK_FORMAT", "REPLICA_NUM", "TABLET_SIZE", "USE_BLOOM_FILTER", "AUTO_INCREMENT", "AVG_ROW_LENGTH", "CHECKSUM", "CONNECTION", "DELAY_KEY_WRITE", "FULLTEXT_DICT", "INSERT_METHOD", "KEY_BLOCK_SIZE", "MAX_ROWS", "MIN_ROWS", "PACK_KEYS", "PASSWORD", "ROW_FORMAT", "STATS_AUTO_RECALC", "STATS_PERSISTENT", "STATS_SAMPLE_PAGES", "STORAGE_TYPE", "TABLE_PROPERTIES", "ENCRYPTION", "COMPRESSION", "STORAGE_POLICY"}) {
            this.supportOptions.add(FnvHash.hashCode64(supportName));
        }
    }

    @Override
    public MySqlExprParser getExprParser() {
        return (MySqlExprParser)this.exprParser;
    }

    @Override
    public MySqlCreateTableStatement parseCreateTable() {
        SQLSelect query;
        MySqlCreateTableStatement stmt = new MySqlCreateTableStatement();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            stmt.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.CREATE);
        if (this.lexer.nextIfIdentifier("TEMPORARY")) {
            stmt.config(SQLCreateTableStatement.Feature.Temporary);
        } else if (this.lexer.nextIfIdentifier("SHADOW")) {
            stmt.config(SQLCreateTableStatement.Feature.Shadow);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.nextToken();
            stmt.setDimension(true);
        }
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(stmt.getHints());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExternal(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLName name = this.exprParser.name();
            stmt.setLike(name);
        }
        if (this.lexer.token() == Token.WITH) {
            query = new MySqlSelectParser(this.exprParser).select();
            stmt.setSelect(query);
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                query = new MySqlSelectParser(this.exprParser).select();
                stmt.setSelect(query);
            } else {
                while (true) {
                    MySqlTableIndex idx;
                    MySqlKey clsKey;
                    MySqlTableIndex idx2;
                    MySqlKey fulltextKey;
                    Lexer.SavePoint mark;
                    SQLColumnDefinition column = null;
                    boolean global = false;
                    if (this.lexer.identifierEquals(FnvHash.Constants.GLOBAL)) {
                        Lexer.SavePoint mark2 = this.lexer.mark();
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.INDEX || this.lexer.token() == Token.UNIQUE) {
                            global = true;
                        } else {
                            this.lexer.reset(mark2);
                        }
                    }
                    boolean local = false;
                    if (this.lexer.identifierEquals(FnvHash.Constants.LOCAL)) {
                        mark = this.lexer.mark();
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.INDEX || this.lexer.token() == Token.KEY || this.lexer.token() == Token.UNIQUE) {
                            local = true;
                        } else if (this.lexer.token() == Token.FULLTEXT) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == Token.KEY) {
                                fulltextKey = new MySqlKey();
                                this.exprParser.parseIndex(fulltextKey.getIndexDefinition());
                                fulltextKey.setIndexType("FULLTEXT");
                                fulltextKey.setParent(stmt);
                                stmt.getTableElementList().add(fulltextKey);
                                while (this.lexer.token() == Token.HINT) {
                                    this.lexer.nextToken();
                                }
                                if (this.lexer.token() == Token.RPAREN) break;
                                if (this.lexer.token() == Token.COMMA) {
                                    this.lexer.nextToken();
                                    continue;
                                }
                            } else if (this.lexer.token() == Token.INDEX) {
                                MySqlTableIndex idx3 = new MySqlTableIndex();
                                this.exprParser.parseIndex(idx3.getIndexDefinition());
                                idx3.setIndexType("FULLTEXT");
                                idx3.setParent(stmt);
                                stmt.getTableElementList().add(idx3);
                                if (this.lexer.token() == Token.RPAREN) break;
                                if (this.lexer.token() == Token.COMMA) {
                                    this.lexer.nextToken();
                                    continue;
                                }
                            } else if (this.lexer.token() == Token.IDENTIFIER && MySqlUtils.isBuiltinDataType(this.lexer.stringVal())) {
                                this.lexer.reset(mark);
                            } else {
                                MySqlTableIndex idx4 = new MySqlTableIndex();
                                this.exprParser.parseIndex(idx4.getIndexDefinition());
                                idx4.setIndexType("FULLTEXT");
                                idx4.setParent(stmt);
                                stmt.getTableElementList().add(idx4);
                                if (this.lexer.token() == Token.RPAREN) break;
                                if (this.lexer.token() == Token.COMMA) {
                                    this.lexer.nextToken();
                                    continue;
                                }
                            }
                        } else if (this.lexer.identifierEquals(FnvHash.Constants.SPATIAL)) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == Token.INDEX || this.lexer.token() == Token.KEY || this.lexer.token() != Token.IDENTIFIER || !MySqlUtils.isBuiltinDataType(this.lexer.stringVal())) {
                                MySqlTableIndex idx5 = new MySqlTableIndex();
                                this.exprParser.parseIndex(idx5.getIndexDefinition());
                                idx5.setIndexType("SPATIAL");
                                idx5.setParent(stmt);
                                stmt.getTableElementList().add(idx5);
                                if (this.lexer.token() == Token.RPAREN) break;
                                if (this.lexer.token() == Token.COMMA) {
                                    this.lexer.nextToken();
                                    continue;
                                }
                            } else {
                                this.lexer.reset(mark);
                            }
                        } else {
                            this.lexer.reset(mark);
                        }
                    }
                    if (this.lexer.token() == Token.FULLTEXT) {
                        mark = this.lexer.mark();
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.KEY) {
                            fulltextKey = new MySqlKey();
                            this.exprParser.parseIndex(fulltextKey.getIndexDefinition());
                            fulltextKey.setIndexType("FULLTEXT");
                            fulltextKey.setParent(stmt);
                            stmt.getTableElementList().add(fulltextKey);
                            while (this.lexer.token() == Token.HINT) {
                                this.lexer.nextToken();
                            }
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        } else if (this.lexer.token() == Token.INDEX) {
                            idx2 = new MySqlTableIndex();
                            this.exprParser.parseIndex(idx2.getIndexDefinition());
                            idx2.setIndexType("FULLTEXT");
                            idx2.setParent(stmt);
                            stmt.getTableElementList().add(idx2);
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        } else if (this.lexer.token() == Token.IDENTIFIER && MySqlUtils.isBuiltinDataType(this.lexer.stringVal())) {
                            this.lexer.reset(mark);
                        } else {
                            idx2 = new MySqlTableIndex();
                            this.exprParser.parseIndex(idx2.getIndexDefinition());
                            idx2.setIndexType("FULLTEXT");
                            idx2.setParent(stmt);
                            stmt.getTableElementList().add(idx2);
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        }
                    } else if (this.lexer.identifierEquals(FnvHash.Constants.SPATIAL)) {
                        mark = this.lexer.mark();
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.INDEX || this.lexer.token() == Token.KEY || this.lexer.token() != Token.IDENTIFIER || !MySqlUtils.isBuiltinDataType(this.lexer.stringVal())) {
                            idx2 = new MySqlTableIndex();
                            this.exprParser.parseIndex(idx2.getIndexDefinition());
                            idx2.setIndexType("SPATIAL");
                            idx2.setParent(stmt);
                            stmt.getTableElementList().add(idx2);
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        } else {
                            this.lexer.reset(mark);
                        }
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.ANN)) {
                        mark = this.lexer.mark();
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.INDEX || this.lexer.token() == Token.KEY) {
                            idx2 = new MySqlTableIndex();
                            this.exprParser.parseIndex(idx2.getIndexDefinition());
                            idx2.setIndexType("ANN");
                            idx2.setParent(stmt);
                            stmt.getTableElementList().add(idx2);
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        } else {
                            this.lexer.reset(mark);
                        }
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.KEY) {
                            clsKey = new MySqlKey();
                            this.exprParser.parseIndex(clsKey.getIndexDefinition());
                            clsKey.setIndexType("CLUSTERED");
                            clsKey.setParent(stmt);
                            stmt.getTableElementList().add(clsKey);
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        } else if (this.lexer.token() == Token.INDEX) {
                            idx = new MySqlTableIndex();
                            this.exprParser.parseIndex(idx.getIndexDefinition());
                            idx.setIndexType("CLUSTERED");
                            idx.setParent(stmt);
                            stmt.getTableElementList().add(idx);
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        }
                    } else if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERING)) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.KEY) {
                            clsKey = new MySqlKey();
                            this.exprParser.parseIndex(clsKey.getIndexDefinition());
                            clsKey.setIndexType("CLUSTERING");
                            clsKey.setParent(stmt);
                            stmt.getTableElementList().add(clsKey);
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        } else if (this.lexer.token() == Token.INDEX) {
                            idx = new MySqlTableIndex();
                            this.exprParser.parseIndex(idx.getIndexDefinition());
                            idx.setIndexType("CLUSTERING");
                            idx.setParent(stmt);
                            stmt.getTableElementList().add(idx);
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        }
                    } else if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_CHARS) {
                        column = this.exprParser.parseColumn();
                        column.setParent(stmt);
                        stmt.getTableElementList().add(column);
                        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                            column.addAfterComment(this.lexer.readAndResetComments());
                        }
                    } else if (this.lexer.token() == Token.CONSTRAINT || this.lexer.token() == Token.PRIMARY || this.lexer.token() == Token.UNIQUE) {
                        SQLTableConstraint constraint = this.parseConstraint();
                        constraint.setParent(stmt);
                        if (constraint instanceof MySqlUnique) {
                            MySqlUnique unique = (MySqlUnique)constraint;
                            if (global) {
                                unique.setGlobal(true);
                            }
                            if (local) {
                                unique.setLocal(true);
                            }
                        }
                        stmt.getTableElementList().add(constraint);
                    } else if (this.lexer.token() == Token.INDEX) {
                        idx = new MySqlTableIndex();
                        this.exprParser.parseIndex(idx.getIndexDefinition());
                        if (global) {
                            idx.getIndexDefinition().setGlobal(true);
                        }
                        if (local) {
                            idx.getIndexDefinition().setLocal(true);
                        }
                        idx.setParent(stmt);
                        stmt.getTableElementList().add(idx);
                    } else if (this.lexer.token() == Token.KEY) {
                        Lexer.SavePoint savePoint = this.lexer.mark();
                        this.lexer.nextToken();
                        boolean isColumn = false;
                        if (this.lexer.identifierEquals(FnvHash.Constants.VARCHAR)) {
                            isColumn = true;
                        }
                        this.lexer.reset(savePoint);
                        if (isColumn) {
                            column = this.exprParser.parseColumn();
                            stmt.getTableElementList().add(column);
                        } else {
                            stmt.getTableElementList().add(this.parseConstraint());
                        }
                    } else if (this.lexer.token() == Token.PRIMARY) {
                        SQLTableConstraint pk = this.parseConstraint();
                        pk.setParent(stmt);
                        stmt.getTableElementList().add(pk);
                    } else if (this.lexer.token() == Token.FOREIGN) {
                        MysqlForeignKey fk = this.getExprParser().parseForeignKey();
                        fk.setParent(stmt);
                        stmt.getTableElementList().add(fk);
                    } else if (this.lexer.token() == Token.CHECK) {
                        SQLCheck check = this.exprParser.parseCheck();
                        stmt.getTableElementList().add(check);
                    } else if (this.lexer.token() == Token.LIKE) {
                        this.lexer.nextToken();
                        SQLTableLike tableLike = new SQLTableLike();
                        tableLike.setTable(new SQLExprTableSource(this.exprParser.name()));
                        tableLike.setParent(stmt);
                        stmt.getTableElementList().add(tableLike);
                        if (this.lexer.identifierEquals(FnvHash.Constants.INCLUDING)) {
                            this.lexer.nextToken();
                            this.acceptIdentifier("PROPERTIES");
                            tableLike.setIncludeProperties(true);
                        } else if (this.lexer.identifierEquals(FnvHash.Constants.EXCLUDING)) {
                            this.lexer.nextToken();
                            this.acceptIdentifier("PROPERTIES");
                            tableLike.setExcludeProperties(true);
                        }
                    } else {
                        column = this.exprParser.parseColumn();
                        stmt.getTableElementList().add(column);
                    }
                    if (this.lexer.token() == Token.HINT) {
                        this.lexer.nextToken();
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                    if (!this.lexer.isKeepComments() || !this.lexer.hasComment() || column == null) continue;
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
            }
            if (this.lexer.token() == Token.HINT) {
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.HINT && this.lexer.stringVal().charAt(0) == '!') {
                this.lexer.nextToken();
            }
        }
        this.parseOptions(stmt);
        if (this.lexer.token() == Token.ON) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        if (this.lexer.token() == Token.REPLACE) {
            this.lexer.nextToken();
            stmt.setReplace(true);
        } else if (this.lexer.identifierEquals("IGNORE")) {
            this.lexer.nextToken();
            stmt.setIgnore(true);
        } else if (this.lexer.identifierEquals("SINGLE")) {
            this.lexer.nextToken();
            stmt.setSingle(true);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                query = new MySqlSelectParser(this.exprParser).select();
                stmt.setSelect(query);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.WITH) {
                stmt.setWithSelect(this.parseWith());
            }
        }
        SQLCommentHint hint = null;
        if (this.lexer.token() == Token.HINT) {
            hint = this.exprParser.parseHint();
        }
        if (this.lexer.token() == Token.SELECT) {
            SQLSelect query2 = new MySqlSelectParser(this.exprParser).select();
            if (hint != null) {
                query2.setHeadHint(hint);
            }
            stmt.setSelect(query2);
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.NO)) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("DATA");
                    stmt.setWithData(false);
                } else {
                    this.acceptIdentifier("DATA");
                    stmt.setWithData(true);
                }
            }
        }
        while (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(stmt.getOptionHints());
        }
        return stmt;
    }

    public SQLPartitionBy parseLocalPartitionBy() {
        this.lexer.nextToken();
        this.accept(Token.PARTITION);
        this.accept(Token.BY);
        this.acceptIdentifier("RANGE");
        SQLPartitionByRange partitionClause = new SQLPartitionByRange();
        this.accept(Token.LPAREN);
        partitionClause.addColumn(this.exprParser.name());
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.STARTWITH)) {
            this.lexer.nextToken();
            partitionClause.setStartWith(this.exprParser.expr());
        }
        partitionClause.setInterval(this.getExprParser().parseInterval());
        if (this.lexer.identifierEquals("EXPIRE")) {
            this.acceptIdentifier("EXPIRE");
            this.acceptIdentifier("AFTER");
            partitionClause.setExpireAfter((SQLIntegerExpr)this.exprParser.expr());
        }
        if (this.lexer.identifierEquals("PRE")) {
            this.acceptIdentifier("PRE");
            this.acceptIdentifier("ALLOCATE");
            partitionClause.setPreAllocate((SQLIntegerExpr)this.exprParser.expr());
        }
        if (this.lexer.identifierEquals("PIVOTDATE")) {
            this.acceptIdentifier("PIVOTDATE");
            partitionClause.setPivotDateExpr(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.DISABLE) {
            this.lexer.nextToken();
            this.acceptIdentifier("SCHEDULE");
            partitionClause.setDisableSchedule(true);
        }
        return partitionClause;
    }

    protected boolean parseOption(MySqlCreateTableStatement stmt) {
        if (this.lexer.token() == Token.IDENTIFIER && this.supportOptions.contains(this.lexer.hashLCase())) {
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr expr = this.exprParser.expr();
            stmt.addOption(name.toUpperCase(), expr);
            return true;
        }
        return false;
    }

    protected void parseOptions(MySqlCreateTableStatement stmt) {
        while (true) {
            SQLExpr value;
            Object name;
            SQLExpr expr;
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                expr = null;
                if (this.lexer.token() == Token.MERGE) {
                    expr = new SQLIdentifierExpr(this.lexer.stringVal());
                    this.lexer.nextToken();
                } else {
                    expr = this.exprParser.expr();
                }
                stmt.setEngine(expr);
                continue;
            }
            if (this.parseOption(stmt)) continue;
            if (this.lexer.identifierEquals(FnvHash.Constants.BLOCK_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                expr = null;
                if (this.lexer.token() == Token.MERGE) {
                    expr = new SQLIdentifierExpr(this.lexer.stringVal());
                    this.lexer.nextToken();
                } else {
                    expr = this.exprParser.integerExpr();
                }
                stmt.addOption("BLOCK_SIZE", expr);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PCTFREE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                expr = this.exprParser.integerExpr();
                stmt.addOption("PCTFREE", expr);
                continue;
            }
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                this.parseTableOptionCharsetOrCollate(stmt);
                continue;
            }
            if (this.parseTableOptionCharsetOrCollate(stmt)) continue;
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.setComment(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.addOption("DATA DIRECTORY", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.addOption("INDEX DIRECTORY", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.UNION) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                this.accept(Token.LPAREN);
                SQLListExpr list = new SQLListExpr();
                this.exprParser.exprList(list.getItems(), list);
                stmt.addOption("UNION", list);
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                MySqlCreateTableStatement.TableSpaceOption option = new MySqlCreateTableStatement.TableSpaceOption();
                option.setName(this.exprParser.name());
                if (this.lexer.identifierEquals("STORAGE")) {
                    this.lexer.nextToken();
                    option.setStorage(this.exprParser.name());
                }
                stmt.addOption("TABLESPACE", option);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TABLEGROUP)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName tableGroup = this.exprParser.name();
                stmt.setTableGroup(tableGroup);
                continue;
            }
            if (this.lexer.identifierEquals("INDEX_ALL")) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                if (this.lexer.token() != Token.LITERAL_CHARS) continue;
                if ("Y".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    stmt.addOption("INDEX_ALL", new SQLCharExpr("Y"));
                    continue;
                }
                if ("N".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    stmt.addOption("INDEX_ALL", new SQLCharExpr("N"));
                    continue;
                }
                throw new ParserException("INDEX_ALL accept parameter ['Y' or 'N'] only.");
            }
            if (this.lexer.identifierEquals("RT_INDEX_ALL")) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                if (this.lexer.token() != Token.LITERAL_CHARS) continue;
                if ("Y".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    stmt.addOption("RT_INDEX_ALL", new SQLCharExpr("Y"));
                    continue;
                }
                if ("N".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    stmt.addOption("RT_INDEX_ALL", new SQLCharExpr("N"));
                    continue;
                }
                throw new ParserException("RT_INDEX_ALL accepts parameter ['Y' or 'N'] only.");
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                this.acceptIdentifier("OSS");
                stmt.setArchiveBy(new SQLIdentifierExpr("OSS"));
                continue;
            }
            if (this.lexer.identifierEquals("HOT_PARTITION_COUNT")) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                try {
                    stmt.addOption("HOT_PARTITION_COUNT", this.exprParser.integerExpr());
                }
                catch (Exception e) {
                    throw new ParserException("only integer number is supported for hot_partition_count");
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                this.accept(Token.LPAREN);
                while (true) {
                    SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                    stmt.addClusteredByItem(item);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.token() == Token.PARTITION) {
                SQLPartitionBy partitionClause = this.parsePartitionBy();
                stmt.setPartitionBy(partitionClause);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LOCAL)) {
                SQLPartitionBy localPartitionClause = this.parseLocalPartitionBy();
                stmt.setLocalPartitioning(localPartitionClause);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.BROADCAST)) {
                this.lexer.nextToken();
                stmt.setBroadCast(true);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTE) || this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTED)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.identifierEquals(FnvHash.Constants.HASH)) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    while (true) {
                        name = this.exprParser.name();
                        stmt.getDistributeBy().add((SQLName)name);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    stmt.setDistributeByType(new SQLIdentifierExpr("HASH"));
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.DUPLICATE)) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    while (true) {
                        name = this.exprParser.name();
                        stmt.getDistributeBy().add((SQLName)name);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    stmt.setDistributeByType(new SQLIdentifierExpr("DUPLICATE"));
                    continue;
                }
                if (!this.lexer.identifierEquals(FnvHash.Constants.BROADCAST)) continue;
                this.lexer.nextToken();
                stmt.setDistributeByType(new SQLIdentifierExpr("BROADCAST"));
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DBPARTITION)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                SQLExpr dbPartitoinBy = this.exprParser.primary();
                stmt.setDbPartitionBy(dbPartitoinBy);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DBPARTITIONS)) {
                this.lexer.nextToken();
                SQLExpr dbPartitions = this.exprParser.primary();
                stmt.setDbPartitions(dbPartitions);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TBPARTITION)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                expr = this.exprParser.expr();
                if (this.lexer.identifierEquals(FnvHash.Constants.STARTWITH)) {
                    this.lexer.nextToken();
                    SQLExpr start = this.exprParser.primary();
                    this.acceptIdentifier("ENDWITH");
                    SQLExpr end = this.exprParser.primary();
                    expr = new SQLBetweenExpr(expr, start, end);
                }
                stmt.setTablePartitionBy(expr);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TBPARTITIONS)) {
                this.lexer.nextToken();
                SQLExpr tbPartitions = this.exprParser.primary();
                stmt.setTablePartitions(tbPartitions);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.EXTPARTITION)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                MySqlExtPartition partitionDef = new MySqlExtPartition();
                while (true) {
                    SQLExpr value2;
                    SQLName name2;
                    MySqlExtPartition.Item item = new MySqlExtPartition.Item();
                    if (this.lexer.identifierEquals(FnvHash.Constants.DBPARTITION)) {
                        this.lexer.nextToken();
                        name2 = this.exprParser.name();
                        item.setDbPartition(name2);
                        this.accept(Token.BY);
                        value2 = this.exprParser.primary();
                        item.setDbPartitionBy(value2);
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.TBPARTITION)) {
                        this.lexer.nextToken();
                        name2 = this.exprParser.name();
                        item.setTbPartition(name2);
                        this.accept(Token.BY);
                        value2 = this.exprParser.primary();
                        item.setTbPartitionBy(value2);
                    }
                    item.setParent(partitionDef);
                    partitionDef.getItems().add(item);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                stmt.setExPartition(partitionDef);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.OPTIONS)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                stmt.putAttribute("ads.options", Boolean.TRUE);
                while (true) {
                    name = this.lexer.stringVal();
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    value = this.exprParser.primary();
                    stmt.addOption((String)name, value);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                name = this.exprParser.name();
                stmt.setStoredBy((SQLName)name);
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    name = this.lexer.stringVal();
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    value = this.exprParser.name();
                    stmt.getWith().put((String)name, (SQLName)value);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.token() == Token.HINT) {
                this.exprParser.parseHints(stmt.getOptionHints());
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.SINGLE)) break;
            this.lexer.nextToken();
            stmt.setSingle(true);
        }
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        SQLPartitionBy partitionClause;
        SQLPartitionBy clause;
        this.lexer.nextToken();
        this.accept(Token.BY);
        boolean linera = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.LINEAR)) {
            this.lexer.nextToken();
            linera = true;
        }
        if (this.lexer.token() == Token.KEY) {
            clause = new MySqlPartitionByKey();
            this.lexer.nextToken();
            if (linera) {
                clause.setLinear(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ALGORITHM)) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                ((MySqlPartitionByKey)clause).setAlgorithm(this.lexer.integerValue().shortValue());
                this.lexer.nextToken();
            }
            this.accept(Token.LPAREN);
            if (this.lexer.token() != Token.RPAREN) {
                while (true) {
                    clause.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            this.accept(Token.RPAREN);
            partitionClause = clause;
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.HASH) || this.lexer.identifierEquals("UNI_HASH")) {
            clause = new SQLPartitionByHash();
            if (this.lexer.identifierEquals("UNI_HASH")) {
                ((SQLPartitionByHash)clause).setUnique(true);
            }
            this.lexer.nextToken();
            if (linera) {
                clause.setLinear(true);
            }
            if (this.lexer.token() == Token.KEY) {
                this.lexer.nextToken();
                ((SQLPartitionByHash)clause).setKey(true);
            }
            this.accept(Token.LPAREN);
            this.exprParser.exprList(clause.getColumns(), clause);
            this.accept(Token.RPAREN);
            partitionClause = clause;
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            partitionClause = clause = this.partitionByRange();
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            partitionClause = clause = this.partitionByValue();
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.LIST)) {
            this.lexer.nextToken();
            clause = new SQLPartitionByList();
            if (this.lexer.token() == Token.LPAREN) {
                ((SQLPartitionByList)clause).setType(SQLPartitionByList.PartitionByListType.LIST_EXPRESSION);
                this.lexer.nextToken();
                clause.addColumn(this.exprParser.expr());
                this.accept(Token.RPAREN);
            } else {
                this.acceptIdentifier(FnvHash.Constants.COLUMNS);
                ((SQLPartitionByList)clause).setType(SQLPartitionByList.PartitionByListType.LIST_COLUMNS);
                this.accept(Token.LPAREN);
                while (true) {
                    clause.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            partitionClause = clause;
            this.partitionClauseRest(clause);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            partitionClause = clause = this.partitionByRange();
            this.partitionClauseRest(clause);
        } else {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
            this.lexer.nextToken();
            partitionClause.setLifeCycle((SQLIntegerExpr)this.exprParser.expr());
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                MysqlPartitionSingle partitionDef = this.getExprParser().parsePartition();
                partitionClause.addPartition(partitionDef);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return partitionClause;
    }

    protected SQLPartitionByRange partitionByRange1() {
        this.acceptIdentifier("RANGE");
        SQLPartitionByRange clause = new SQLPartitionByRange();
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            clause.addColumn(this.exprParser.expr());
            this.accept(Token.RPAREN);
        } else {
            this.acceptIdentifier("COLUMNS");
            this.accept(Token.LPAREN);
            while (true) {
                clause.addColumn(this.exprParser.name());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return clause;
    }

    protected SQLPartitionByValue partitionByValue() {
        SQLPartitionByValue clause = new SQLPartitionByValue();
        if (this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                clause.addColumn(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
        }
        return clause;
    }

    protected SQLPartitionByRange partitionByRange() {
        SQLPartitionByRange clause = new SQLPartitionByRange();
        if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                clause.addColumn(this.exprParser.expr());
                this.accept(Token.RPAREN);
            } else {
                this.acceptIdentifier("COLUMNS");
                this.accept(Token.LPAREN);
                while (true) {
                    clause.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
        } else {
            SQLExpr expr = this.exprParser.expr();
            if (this.lexer.identifierEquals(FnvHash.Constants.STARTWITH)) {
                this.lexer.nextToken();
                SQLExpr start = this.exprParser.primary();
                this.acceptIdentifier("ENDWITH");
                SQLExpr end = this.exprParser.primary();
                expr = new SQLBetweenExpr(expr, start, end);
            }
            clause.setInterval(expr);
        }
        return clause;
    }

    protected void partitionClauseRest(SQLPartitionBy clause) {
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS) || this.lexer.identifierEquals(FnvHash.Constants.TBPARTITIONS) || this.lexer.identifierEquals(FnvHash.Constants.DBPARTITIONS)) {
            this.lexer.nextToken();
            SQLIntegerExpr countExpr = this.exprParser.integerExpr();
            clause.setPartitionsCount(countExpr);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("NUM")) {
                this.lexer.nextToken();
            }
            clause.setPartitionsCount(this.exprParser.expr());
            clause.putAttribute("ads.partition", Boolean.TRUE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
            this.lexer.nextToken();
            clause.setLifeCycle((SQLIntegerExpr)this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSubPartitionBy subPartitionByClause = null;
            boolean linear = false;
            if (this.lexer.identifierEquals("LINEAR")) {
                this.lexer.nextToken();
                linear = true;
            }
            if (this.lexer.token() == Token.KEY) {
                MySqlSubPartitionByKey subPartitionKey = new MySqlSubPartitionByKey();
                this.lexer.nextToken();
                if (linear) {
                    clause.setLinear(true);
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.ALGORITHM)) {
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    subPartitionKey.setAlgorithm(this.lexer.integerValue().shortValue());
                    this.lexer.nextToken();
                }
                this.accept(Token.LPAREN);
                while (true) {
                    subPartitionKey.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionKey;
            } else if (this.lexer.identifierEquals("VALUE")) {
                MySqlSubPartitionByValue subPartitionByValue = new MySqlSubPartitionByValue();
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    subPartitionByValue.addColumn(this.exprParser.expr());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionByValue;
            } else if (this.lexer.identifierEquals("HASH")) {
                this.lexer.nextToken();
                SQLSubPartitionByHash subPartitionHash = new SQLSubPartitionByHash();
                if (linear) {
                    clause.setLinear(true);
                }
                if (this.lexer.token() == Token.KEY) {
                    this.lexer.nextToken();
                    subPartitionHash.setKey(true);
                }
                this.accept(Token.LPAREN);
                subPartitionHash.setExpr(this.exprParser.expr());
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionHash;
            } else if (this.lexer.identifierEquals("LIST")) {
                SQLExpr expr;
                this.lexer.nextToken();
                MySqlSubPartitionByList subPartitionList = new MySqlSubPartitionByList();
                if (this.lexer.token() == Token.KEY) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    while (true) {
                        if ((expr = this.exprParser.expr()) instanceof SQLIdentifierExpr && (this.lexer.identifierEquals("bigint") || this.lexer.identifierEquals("long"))) {
                            String dataType = this.lexer.stringVal();
                            this.lexer.nextToken();
                            SQLColumnDefinition column = this.exprParser.createColumnDefinition();
                            column.setName((SQLIdentifierExpr)expr);
                            column.setDataType(new SQLDataTypeImpl(dataType));
                            subPartitionList.addColumn(column);
                            subPartitionList.putAttribute("ads.subPartitionList", Boolean.TRUE);
                        }
                        subPartitionList.addKey(expr);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    subPartitionList.putAttribute("ads.subPartitionList", Boolean.TRUE);
                    this.accept(Token.RPAREN);
                } else if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LITERAL_ALIAS) {
                        expr = new SQLIdentifierExpr(this.lexer.stringVal());
                        this.lexer.nextToken();
                    } else {
                        expr = this.exprParser.expr();
                    }
                    if (expr instanceof SQLIdentifierExpr && (this.lexer.identifierEquals("bigint") || this.lexer.identifierEquals("long"))) {
                        String dataType = this.lexer.stringVal();
                        this.lexer.nextToken();
                        SQLColumnDefinition column = this.exprParser.createColumnDefinition();
                        column.setName((SQLIdentifierExpr)expr);
                        column.setDataType(new SQLDataTypeImpl(dataType));
                        subPartitionList.addColumn(column);
                        subPartitionList.putAttribute("ads.subPartitionList", Boolean.TRUE);
                    } else {
                        subPartitionList.addKey(expr);
                    }
                    this.accept(Token.RPAREN);
                } else {
                    this.acceptIdentifier("COLUMNS");
                    this.accept(Token.LPAREN);
                    while (true) {
                        subPartitionList.addColumn(this.exprParser.parseColumn());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                subPartitionByClause = subPartitionList;
            } else if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
                this.lexer.nextToken();
                SQLSubPartitionByRange range = new SQLSubPartitionByRange();
                this.accept(Token.LPAREN);
                this.exprParser.exprList(range.getColumns(), range);
                this.accept(Token.RPAREN);
                subPartitionByClause = range;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION)) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTIONS");
                this.exprParser.parseAssignItem(subPartitionByClause.getOptions(), (SQLObject)subPartitionByClause);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITIONS)) {
                this.lexer.nextToken();
                Number intValue = this.lexer.integerValue();
                SQLNumberExpr numExpr = new SQLNumberExpr(intValue);
                subPartitionByClause.setSubPartitionsCount(numExpr);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                this.lexer.nextToken();
                subPartitionByClause.setSubPartitionsCount((SQLIntegerExpr)this.exprParser.expr());
                subPartitionByClause.getAttributes().put("adb.partitons", true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextToken();
                subPartitionByClause.setLifecycle((SQLIntegerExpr)this.exprParser.expr());
            }
            if (subPartitionByClause != null) {
                subPartitionByClause.setLinear(linear);
                clause.setSubPartitionBy(subPartitionByClause);
            }
        }
    }

    private boolean parseTableOptionCharsetOrCollate(MySqlCreateTableStatement stmt) {
        if (this.lexer.identifierEquals("CHARACTER")) {
            SQLExpr charset;
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                charset = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.LITERAL_CHARS) {
                charset = new SQLCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
            } else {
                charset = this.exprParser.primary();
            }
            stmt.addOption("CHARACTER SET", charset);
            return true;
        }
        if (this.lexer.identifierEquals("CHARSET")) {
            SQLExpr charset;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                charset = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.LITERAL_CHARS) {
                charset = new SQLCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
            } else {
                charset = this.exprParser.primary();
            }
            stmt.addOption("CHARSET", charset);
            return true;
        }
        if (this.lexer.identifierEquals("COLLATE")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.addOption("COLLATE", this.exprParser.expr());
            return true;
        }
        if (this.lexer.identifierEquals("LOCALITY")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.addOption("LOCALITY", this.exprParser.expr());
            return true;
        }
        return false;
    }

    @Override
    protected SQLTableConstraint parseConstraint() {
        SQLName name = null;
        boolean hasConstaint = false;
        if (this.lexer.token() == Token.CONSTRAINT) {
            hasConstaint = true;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            name = this.exprParser.name();
        }
        SQLConstraintImpl constraint = null;
        if (this.lexer.token() == Token.KEY) {
            MySqlKey key = new MySqlKey();
            this.exprParser.parseIndex(key.getIndexDefinition());
            key.setHasConstraint(hasConstaint);
            if (name != null) {
                key.setName(name);
            }
            constraint = key;
        } else if (this.lexer.token() == Token.PRIMARY) {
            MySqlPrimaryKey pk = this.getExprParser().parsePrimaryKey();
            if (name != null) {
                pk.setName(name);
            }
            pk.setHasConstraint(hasConstaint);
            constraint = pk;
        } else if (this.lexer.token() == Token.UNIQUE) {
            MySqlUnique uk = this.getExprParser().parseUnique();
            if (name != null && uk.getName() == null) {
                uk.setName(name);
            }
            uk.setHasConstraint(hasConstaint);
            constraint = uk;
        } else if (this.lexer.token() == Token.FOREIGN) {
            MysqlForeignKey fk = this.getExprParser().parseForeignKey();
            fk.setName(name);
            fk.setHasConstraint(hasConstaint);
            constraint = fk;
        } else if (this.lexer.token() == Token.CHECK) {
            this.lexer.nextToken();
            SQLCheck check = new SQLCheck();
            check.setName(name);
            SQLExpr expr = this.exprParser.primary();
            check.setExpr(expr);
            constraint = check;
            boolean enforce = true;
            if (Token.NOT.equals((Object)this.lexer.token())) {
                enforce = false;
                this.lexer.nextToken();
            }
            if (this.lexer.stringVal().equalsIgnoreCase("ENFORCED")) {
                check.setEnforced(enforce);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.HINT) {
                String hintText = this.lexer.stringVal();
                if (hintText != null) {
                    hintText = hintText.trim();
                }
                if (hintText.startsWith("!")) {
                    if (hintText.endsWith("NOT ENFORCED")) {
                        check.setEnforced(false);
                    } else if (hintText.endsWith(" ENFORCED")) {
                        check.setEnforced(true);
                    }
                    this.lexer.nextToken();
                }
            }
        }
        if (constraint != null) {
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                SQLExpr comment = this.exprParser.primary();
                constraint.setComment(comment);
            }
            return constraint;
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }
}

