/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.bigquery.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLKeep;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryAssertStatement;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryCharExpr;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryCreateTableStatement;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryDateTimeExpr;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQuerySelectQueryBlock;
import com.alibaba.druid.sql.dialect.bigquery.visitor.BigQueryVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class BigQueryOutputVisitor
extends SQLASTOutputVisitor
implements BigQueryVisitor {
    public BigQueryOutputVisitor(StringBuilder appender) {
        super(appender, DbType.bigquery);
    }

    public BigQueryOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.bigquery;
    }

    @Override
    protected void printPartitionedBy(SQLCreateTableStatement x) {
        if (!(x instanceof BigQueryCreateTableStatement)) {
            return;
        }
        List<SQLExpr> partitionBy = ((BigQueryCreateTableStatement)x).getPartitionBy();
        if (partitionBy.isEmpty()) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "PARTITION BY " : "partition by ");
        this.printAndAccept(((BigQueryCreateTableStatement)x).getPartitionBy(), ",");
    }

    @Override
    protected void printPartitionedByColumn(SQLColumnDefinition column) {
        String function = (String)column.getName().getAttribute("function");
        if (function != null) {
            this.print0(function);
            this.print('(');
        }
        column.accept(this);
        if (function != null) {
            this.print(')');
        }
    }

    @Override
    protected void printCreateTableLike(SQLCreateTableStatement x) {
        SQLExprTableSource like = x.getLike();
        if (like == null) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "CLONE " : "clone ");
        like.accept(this);
    }

    @Override
    public boolean visit(BigQuerySelectQueryBlock x) {
        return this.visit((SQLSelectQueryBlock)x);
    }

    @Override
    protected void printSelectListBefore(SQLSelectQueryBlock x) {
        if (x instanceof BigQuerySelectQueryBlock) {
            this.printSelectListBefore((BigQuerySelectQueryBlock)x);
            return;
        }
        super.printSelectListBefore(x);
    }

    protected void printSelectListBefore(BigQuerySelectQueryBlock x) {
        BigQuerySelectQueryBlock.DifferentialPrivacy privacy;
        if (x.isAsStruct()) {
            this.print0(this.ucase ? " AS STRUCT" : " as struct");
        }
        if ((privacy = x.getDifferentialPrivacy()) != null) {
            this.incrementIndent();
            this.println();
            privacy.accept(this);
            this.decrementIndent();
        } else {
            this.print(' ');
        }
    }

    @Override
    public boolean visit(BigQuerySelectQueryBlock.DifferentialPrivacy x) {
        this.print0(this.ucase ? "WITH DIFFERENTIAL_PRIVACY" : "with differential_privacy");
        this.println();
        this.print0(this.ucase ? "OPTIONS (" : "options (");
        this.printAndAccept(x.getOptions(), ",");
        this.print(')');
        this.println();
        return false;
    }

    @Override
    protected void printColumnProperties(SQLColumnDefinition x) {
        List<SQLAssignItem> colProperties = x.getColPropertiesDirect();
        if (colProperties == null || colProperties.isEmpty()) {
            return;
        }
        this.print0(this.ucase ? " OPTIONS (" : " options (");
        this.printAndAccept(colProperties, ", ");
        this.print0(this.ucase ? ")" : ")");
    }

    @Override
    public boolean visit(SQLStructDataType.Field x) {
        SQLDataType dataType;
        SQLName name = x.getName();
        if (name != null) {
            name.accept(this);
        }
        if ((dataType = x.getDataType()) != null) {
            this.print(' ');
            dataType.accept(this);
        }
        if (!x.getConstraints().isEmpty()) {
            this.print(' ');
            this.printAndAccept(x.getConstraints(), ",");
        }
        if (!x.getOptions().isEmpty()) {
            this.print(' ');
            this.print0(this.ucase ? "OPTIONS (" : "options (");
            this.printAndAccept(x.getOptions(), ",");
            this.print0(this.ucase ? ")" : ")");
        }
        return false;
    }

    @Override
    protected void printClusteredBy(SQLCreateTableStatement x) {
        List<SQLSelectOrderByItem> clusteredBy = x.getClusteredBy();
        if (clusteredBy.isEmpty()) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "CLUSTER BY " : "cluster by ");
        this.printAndAccept(clusteredBy, ",");
    }

    @Override
    protected void printCreateFunctionBody(SQLCreateFunctionStatement x) {
        this.printCreateFunctionReturns(x);
        String language = x.getLanguage();
        if (language != null) {
            this.println();
            this.print0(this.ucase ? "LANGUAGE " : "language ");
            this.print0(language);
        }
        List<SQLAssignItem> options = x.getOptions();
        this.printOptions(options);
        String wrappedSource = x.getWrappedSource();
        if (wrappedSource != null) {
            this.println();
            this.print0("AS \"\"\"");
            this.print0(wrappedSource);
            this.print0("\"\"\"");
        } else {
            SQLStatement block = x.getBlock();
            if (block != null) {
                this.println();
                this.print0(this.ucase ? "AS (" : "as (");
                block.accept(this);
                this.print(')');
            }
        }
    }

    protected void printOptions(List<SQLAssignItem> options) {
        if (!options.isEmpty()) {
            this.println();
            this.print0(this.ucase ? "OPTIONS (" : "options (");
            this.printAndAccept(options, ",");
            this.print(')');
        }
    }

    @Override
    protected void printCreateFunctionReturns(SQLCreateFunctionStatement x) {
        SQLDataType returnDataType = x.getReturnDataType();
        if (returnDataType == null) {
            return;
        }
        this.println();
        this.print(this.ucase ? "RETURNS " : "returns ");
        returnDataType.accept(this);
    }

    @Override
    protected void printFetchFirst(SQLSelectQueryBlock x) {
        SQLLimit limit = x.getLimit();
        if (limit == null) {
            return;
        }
        this.println();
        limit.accept(this);
    }

    @Override
    protected void printLifeCycle(SQLExpr lifeCycle) {
        if (lifeCycle == null) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "LIFECYCLE = " : "lifecycle = ");
        lifeCycle.accept(this);
    }

    @Override
    public boolean visit(BigQueryAssertStatement x) {
        this.print0(this.ucase ? "ASSERT " : "assert ");
        x.getExpr().accept(this);
        SQLCharExpr as = x.getAs();
        if (as != null) {
            this.println();
            this.print0(this.ucase ? "AS " : "as ");
            as.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        this.tryPrintLparen(x);
        if (x.isTry()) {
            this.print0(this.ucase ? "SAFE_CAST(" : "safe_cast(");
        } else {
            this.print0(this.ucase ? "CAST(" : "cast(");
        }
        x.getExpr().accept(this);
        this.print0(this.ucase ? " AS " : " as ");
        x.getDataType().accept(this);
        SQLExpr format = x.getFormat();
        if (format != null) {
            this.print0(this.ucase ? " FORMAT " : " format ");
            format.accept(this);
        }
        this.print0(")");
        this.tryPrintRparen(x);
        return false;
    }

    @Override
    protected void printTableOption(SQLExpr name, SQLExpr value, int index) {
        if (index != 0) {
            this.print(",");
            this.println();
        }
        String key = name.toString();
        this.print0(key);
        this.print0(" = ");
        value.accept(this);
    }

    @Override
    protected void printCollate(SQLCreateTableStatement x) {
        BigQueryCreateTableStatement bigQueryCreateTableStatement;
        if (x instanceof BigQueryCreateTableStatement && (bigQueryCreateTableStatement = (BigQueryCreateTableStatement)x).getCollate() != null) {
            this.println();
            this.print0(this.ucase ? "DEFAULT COLLATE " : "default collate ");
            bigQueryCreateTableStatement.getCollate().accept(this);
        }
    }

    @Override
    public boolean visit(BigQueryDateTimeExpr x) {
        x.getExpr().accept(this);
        SQLExpr timeZone = x.getTimeZone();
        this.print0(this.ucase ? " AT TIME ZONE " : " at time zone ");
        timeZone.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        SQLExpr filter;
        SQLName overRef;
        SQLOver over;
        SQLExpr arg0;
        List<SQLExpr> arguments;
        boolean parameterized = this.parameterized;
        if (x.methodNameHashCode64() == FnvHash.Constants.GROUP_CONCAT) {
            this.parameterized = false;
        }
        if (x.methodNameHashCode64() == FnvHash.Constants.COUNT && (arguments = x.getArguments()).size() == 1 && (arg0 = arguments.get(0)) instanceof SQLLiteralExpr) {
            this.parameterized = false;
        }
        if (x.getOwner() != null) {
            this.printExpr(x.getOwner());
            this.print(".");
        }
        String methodName = x.getMethodName();
        this.print0(this.ucase ? methodName : methodName.toLowerCase());
        this.print('(');
        SQLAggregateOption option = x.getOption();
        if (option != null) {
            this.print0(option.toString());
            this.print(' ');
        }
        List<SQLExpr> arguments2 = x.getArguments();
        int size = arguments2.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            this.printExpr(arguments2.get(i), false);
        }
        if (x.isIgnoreNulls()) {
            this.print0(this.ucase ? " IGNORE NULLS" : " ignore nulls");
        }
        if (x.isRespectNulls()) {
            this.print0(this.ucase ? " RESPECT NULLS" : " respect nulls");
        }
        this.visitAggregateRest(x);
        this.print(')');
        SQLKeep keep = x.getKeep();
        if (keep != null) {
            this.print(' ');
            this.visit(keep);
        }
        if ((over = x.getOver()) != null) {
            this.print0(this.ucase ? " OVER " : " over ");
            over.accept(this);
        }
        if ((overRef = x.getOverRef()) != null) {
            this.print0(this.ucase ? " OVER " : " over ");
            overRef.accept(this);
        }
        if ((filter = x.getFilter()) != null) {
            this.print0(this.ucase ? " FILTER (WHERE " : " filter (where ");
            this.printExpr(filter);
            this.print(')');
        }
        this.parameterized = parameterized;
        return false;
    }

    @Override
    public boolean visit(BigQueryCharExpr x) {
        if (x.hasPrefix()) {
            this.print0(x.getPrefix());
        }
        if (x.isSpace()) {
            this.print0(" ");
        }
        if (!x.isAlias()) {
            this.print("'");
        }
        this.print(x.getText());
        if (!x.isAlias()) {
            this.print("'");
        }
        return false;
    }

    @Override
    protected void printName0(String text) {
        if (text.length() > 1 && text.charAt(0) != '`' && text.indexOf(45) != -1) {
            this.appender.append('`');
            this.appender.append(text);
            this.appender.append('`');
            return;
        }
        super.printName0(text);
    }

    @Override
    protected void printCreateViewAs(SQLCreateViewStatement x) {
        this.printOptions(x.getOptions());
        super.printCreateViewAs(x);
    }
}

